const fileInput = document.getElementById("fileInput");
const dropZone = document.getElementById("dropZone");

const stepUpload = document.getElementById("step-upload");
const stepEditor = document.getElementById("step-editor");
const stepSuccess = document.getElementById("step-success");

const applyBtn = document.getElementById("applyBtn");
const downloadBtn = document.getElementById("compressBtn");
const loadingOverlay = document.getElementById("loadingOverlay");


let selectedFile = null;
let fileSizeMB = 0;
let selectedMode = "low";


dropZone.onclick = () => fileInput.click();

fileInput.onchange = () => {
  selectedFile = fileInput.files[0];
  if (!selectedFile) return;

  fileSizeMB = (selectedFile.size / 1024 / 1024).toFixed(2);

  document.getElementById("fileName").innerText = selectedFile.name;
  document.getElementById("fileSize").innerText = fileSizeMB + " MB";
  document.getElementById("summaryOriginal").innerText = fileSizeMB + " MB";

  stepUpload.classList.add("hidden");
  stepEditor.classList.remove("hidden");
};


document.querySelectorAll("input[name='compressMode']").forEach(radio => {
  radio.addEventListener("change", e => {
    selectedMode = e.target.value;

    let ratio =
      selectedMode === "high" ? 0.25 :
      selectedMode === "medium" ? 0.45 : 0.65;

    document.getElementById("summaryResult").innerText =
      (fileSizeMB * ratio).toFixed(2) + " MB";
  });
});


applyBtn.onclick = async () => {
  if (!selectedFile) {
    alert("Please select a PDF first");
    return;
  }

  loadingOverlay.classList.remove("hidden");

  const formData = new FormData();
  formData.append("file", selectedFile);
  formData.append("mode", selectedMode);

  const targetSize = document.getElementById("targetSize").value;
  if (targetSize) {
    formData.append("targetSize", targetSize);
  }

  const outputName = document.getElementById("outputFilename").value;
  if (outputName) {
    formData.append("outputName", outputName);
  }

  try {
    const res = await fetch("/compress_pdf", {
      method: "POST",
      body: formData
    });

    if (!res.ok) throw new Error("Compression failed");

    const blob = await res.blob();
    const url = URL.createObjectURL(blob);

    downloadBtn.href = url;
    downloadBtn.download = (outputName || "compressed") + ".pdf";

    stepEditor.classList.add("hidden");
    stepSuccess.classList.remove("hidden");

  } catch (err) {
    alert("Compression error");
    console.error(err);
  } finally {
    loadingOverlay.classList.add("hidden");
  }
};


function resetAll() {
  location.reload();
}