// fileHandler.js

const fileInput = document.getElementById('fileInput');
const uploadArea = document.getElementById('uploadArea');
const fileInfo = document.getElementById('fileInfo');
//const convertBtn = document.getElementById('convertBtn'); // Use convertBtn for this page

// Globally exposed variable to hold the selected file
window.selectedFile = null; 

/**
 * Handles the selected file validation and UI update.
 * @param {File} file - The file object.
 */
/*function handleFile(file) {
    if (file.type !== 'application/pdf') {
        window.showMessage('Please select a PDF file', 'error');
        return;
    }
    
    window.selectedFile = file;
    fileInfo.textContent = `Selected: ${file.name} (${(file.size / 1024 / 1024).toFixed(2)} MB)`;
    fileInfo.style.display = 'block';
    convertBtn.disabled = false;
    window.hideMessage();
}*/

// fileHandler.js (CRITICAL - Confirms dynamic button enabling)

// ... (Existing variables like fileInput, uploadArea, fileInfo, window.selectedFile) ...

function handleFile(file) {
    // --- DETERMINE THE CORRECT BUTTON ---
    const actionButton = document.getElementById('convertBtn') || document.getElementById('rotateBtn'); // Finds the button based on which one exists on the current page
    
    if (file.type !== 'application/pdf') {
        window.showMessage('Please select a PDF file', 'error');
        return;
    }
    
    window.selectedFile = file;
    fileInfo.textContent = `Selected: ${file.name} (${(file.size / 1024 / 1024).toFixed(2)} MB)`;
    fileInfo.style.display = 'block';
    
    // CRITICAL: Enable the determined button
    if (actionButton) {
        actionButton.disabled = false;
    }
    
    window.hideMessage();
}

// ... (Rest of event listeners) ...

// --- Event Listeners ---

// Click to upload
uploadArea.addEventListener('click', (e) => {
    if (e.target.closest('button')) {
        fileInput.click();
    } else if (e.target.id === 'uploadArea') {
         fileInput.click();
    }
});

// File selection
fileInput.addEventListener('change', (e) => {
    const file = e.target.files[0];
    if (file) handleFile(file);
});

// Drag and drop setup
uploadArea.addEventListener('dragover', (e) => { 
    e.preventDefault(); 
    uploadArea.classList.add('dragover'); 
});

uploadArea.addEventListener('dragleave', () => { 
    uploadArea.classList.remove('dragover'); 
});

uploadArea.addEventListener('drop', (e) => {
    e.preventDefault();
    uploadArea.classList.remove('dragover');
    const file = e.dataTransfer.files[0];
    if (file && file.type === 'application/pdf') {
        const dataTransfer = new DataTransfer();
        dataTransfer.items.add(file);
        fileInput.files = dataTransfer.files;
        handleFile(file);
    } else {
        window.showMessage('Please upload a PDF file', 'error');
    }
});