/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import java.lang.reflect.Array;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Locale;
import oracle.jdbc.OracleConnection;
import org.hibernate.HibernateException;
import org.hibernate.boot.model.relational.Database;
import org.hibernate.boot.model.relational.NamedAuxiliaryDatabaseObject;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.Size;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.type.descriptor.ValueBinder;
import org.hibernate.type.descriptor.ValueExtractor;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.BasicPluralJavaType;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.BasicBinder;
import org.hibernate.type.descriptor.jdbc.BasicExtractor;
import org.hibernate.type.descriptor.jdbc.JdbcLiteralFormatter;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.internal.BasicTypeImpl;
import org.hibernate.type.spi.TypeConfiguration;

public class OracleNestedTableJdbcType
implements JdbcType {
    private final JdbcType elementJdbcType;
    private final String typeName;

    public OracleNestedTableJdbcType(JdbcType elementJdbcType, String typeName) {
        this.elementJdbcType = elementJdbcType;
        this.typeName = typeName;
    }

    @Override
    public int getJdbcTypeCode() {
        return 2003;
    }

    @Override
    public int getDdlTypeCode() {
        return 4000;
    }

    public JdbcType getElementJdbcType() {
        return this.elementJdbcType;
    }

    @Override
    public <T> JavaType<T> getJdbcRecommendedJavaTypeMapping(Integer precision, Integer scale, TypeConfiguration typeConfiguration) {
        JavaType elementJavaType = this.elementJdbcType.getJdbcRecommendedJavaTypeMapping(precision, scale, typeConfiguration);
        return typeConfiguration.getJavaTypeRegistry().resolveDescriptor(Array.newInstance(elementJavaType.getJavaTypeClass(), 0).getClass());
    }

    @Override
    public <T> JdbcLiteralFormatter<T> getJdbcLiteralFormatter(JavaType<T> javaTypeDescriptor) {
        return null;
    }

    @Override
    public Class<?> getPreferredJavaTypeClass(WrapperOptions options) {
        return java.sql.Array.class;
    }

    @Override
    public <X> ValueBinder<X> getBinder(final JavaType<X> javaTypeDescriptor) {
        final BasicPluralJavaType containerJavaType = (BasicPluralJavaType)((Object)javaTypeDescriptor);
        return new BasicBinder<X>(javaTypeDescriptor, this){

            private String typeName(WrapperOptions options) {
                return (OracleNestedTableJdbcType.this.typeName == null ? OracleNestedTableJdbcType.getTypeName(options, containerJavaType) : OracleNestedTableJdbcType.this.typeName).toUpperCase(Locale.ROOT);
            }

            @Override
            protected void doBindNull(PreparedStatement st, int index, WrapperOptions options) throws SQLException {
                st.setNull(index, 2003, this.typeName(options));
            }

            @Override
            protected void doBindNull(CallableStatement st, String name, WrapperOptions options) throws SQLException {
                st.setNull(name, 2003, this.typeName(options));
            }

            @Override
            protected void doBind(PreparedStatement st, X value, int index, WrapperOptions options) throws SQLException {
                st.setArray(index, this.getArray(value, containerJavaType, options));
            }

            @Override
            protected void doBind(CallableStatement st, X value, String name, WrapperOptions options) throws SQLException {
                java.sql.Array arr = this.getArray(value, containerJavaType, options);
                try {
                    st.setObject(name, (Object)arr, 2003);
                }
                catch (SQLException ex) {
                    throw new HibernateException("JDBC driver does not support named parameters for setArray. Use positional.", ex);
                }
            }

            private java.sql.Array getArray(X value, BasicPluralJavaType<X> containerJavaType2, WrapperOptions options) throws SQLException {
                Class<?> arrayClass = Array.newInstance(OracleNestedTableJdbcType.this.getElementJdbcType().getPreferredJavaTypeClass(options), 0).getClass();
                Object[] objects = (Object[])javaTypeDescriptor.unwrap(value, arrayClass, options);
                String arrayTypeName = this.typeName(options).toUpperCase(Locale.ROOT);
                OracleConnection oracleConnection = options.getSession().getJdbcCoordinator().getLogicalConnection().getPhysicalConnection().unwrap(OracleConnection.class);
                try {
                    return oracleConnection.createOracleArray(arrayTypeName, (Object)objects);
                }
                catch (Exception e) {
                    throw new HibernateException("Couldn't create a java.sql.Array", e);
                }
            }
        };
    }

    @Override
    public <X> ValueExtractor<X> getExtractor(final JavaType<X> javaTypeDescriptor) {
        return new BasicExtractor<X>(javaTypeDescriptor, this){

            @Override
            protected X doExtract(ResultSet rs, int paramIndex, WrapperOptions options) throws SQLException {
                return javaTypeDescriptor.wrap(rs.getArray(paramIndex), options);
            }

            @Override
            protected X doExtract(CallableStatement statement, int index, WrapperOptions options) throws SQLException {
                return javaTypeDescriptor.wrap(statement.getArray(index), options);
            }

            @Override
            protected X doExtract(CallableStatement statement, String name, WrapperOptions options) throws SQLException {
                return javaTypeDescriptor.wrap(statement.getArray(name), options);
            }
        };
    }

    static String getTypeName(WrapperOptions options, BasicPluralJavaType<?> containerJavaType) {
        Dialect dialect = options.getSessionFactory().getJdbcServices().getDialect();
        return OracleNestedTableJdbcType.getTypeName(containerJavaType.getElementJavaType(), dialect);
    }

    static String getTypeName(JavaType<?> elementJavaType, Dialect dialect) {
        return dialect.getArrayTypeName(elementJavaType.getJavaTypeClass().getSimpleName(), null, null);
    }

    @Override
    public void addAuxiliaryDatabaseObjects(JavaType<?> javaType, Size columnSize, Database database, TypeConfiguration typeConfiguration) {
        Dialect dialect = database.getDialect();
        BasicPluralJavaType pluralJavaType = (BasicPluralJavaType)((Object)javaType);
        JavaType elementJavaType = pluralJavaType.getElementJavaType();
        String elementTypeName = this.typeName == null ? OracleNestedTableJdbcType.getTypeName(elementJavaType, dialect) : this.typeName;
        String elementType = typeConfiguration.getDdlTypeRegistry().getTypeName(this.getElementJdbcType().getDdlTypeCode(), dialect.getSizeStrategy().resolveSize(this.getElementJdbcType(), elementJavaType, columnSize.getPrecision(), columnSize.getScale(), columnSize.getLength()), new BasicTypeImpl(elementJavaType, this.getElementJdbcType()));
        database.addAuxiliaryDatabaseObject(new NamedAuxiliaryDatabaseObject(elementTypeName, database.getDefaultNamespace(), this.getCreateArrayTypeCommand(elementTypeName, elementType), this.getDropArrayTypeCommand(elementTypeName), Collections.emptySet(), true));
    }

    String[] getCreateArrayTypeCommand(String elementTypeName, String elementType) {
        return new String[]{"create or replace type " + elementTypeName + " as table of " + elementType};
    }

    String[] getDropArrayTypeCommand(String elementTypeName) {
        return ArrayHelper.EMPTY_STRING_ARRAY;
    }

    @Override
    public String getExtraCreateTableInfo(JavaType<?> javaType, String columnName, String tableName, Database database) {
        Dialect dialect = database.getDialect();
        BasicPluralJavaType pluralJavaType = (BasicPluralJavaType)((Object)javaType);
        String elementTypeName = OracleNestedTableJdbcType.getTypeName(pluralJavaType.getElementJavaType(), dialect);
        return " nested table " + columnName + " store as \"" + StringHelper.truncate(tableName + " " + columnName + " " + elementTypeName, dialect.getMaxIdentifierLength()) + "\"";
    }

    @Override
    public String getFriendlyName() {
        return this.typeName;
    }

    public String toString() {
        return "OracleArrayTypeDescriptor(" + this.typeName + ")";
    }
}

