/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.signatures.cms;

import com.itextpdf.bouncycastleconnector.BouncyCastleFactoryCreator;
import com.itextpdf.commons.bouncycastle.IBouncyCastleFactory;
import com.itextpdf.commons.bouncycastle.asn1.IASN1Encodable;
import com.itextpdf.commons.bouncycastle.asn1.IASN1EncodableVector;
import com.itextpdf.commons.bouncycastle.asn1.IASN1Enumerated;
import com.itextpdf.commons.bouncycastle.asn1.IASN1InputStream;
import com.itextpdf.commons.bouncycastle.asn1.IASN1Integer;
import com.itextpdf.commons.bouncycastle.asn1.IASN1ObjectIdentifier;
import com.itextpdf.commons.bouncycastle.asn1.IASN1OctetString;
import com.itextpdf.commons.bouncycastle.asn1.IASN1Primitive;
import com.itextpdf.commons.bouncycastle.asn1.IASN1Sequence;
import com.itextpdf.commons.bouncycastle.asn1.IASN1Set;
import com.itextpdf.commons.bouncycastle.asn1.IASN1TaggedObject;
import com.itextpdf.commons.bouncycastle.asn1.IDEROctetString;
import com.itextpdf.commons.bouncycastle.asn1.IDERSequence;
import com.itextpdf.commons.bouncycastle.asn1.IDERSet;
import com.itextpdf.commons.bouncycastle.asn1.IDERTaggedObject;
import com.itextpdf.commons.bouncycastle.asn1.ocsp.IOCSPObjectIdentifiers;
import com.itextpdf.commons.bouncycastle.asn1.x509.IAlgorithmIdentifier;
import com.itextpdf.commons.bouncycastle.asn1.x509.ITBSCertificate;
import com.itextpdf.kernel.exceptions.PdfException;
import com.itextpdf.signatures.CertificateInfo;
import com.itextpdf.signatures.CertificateUtil;
import com.itextpdf.signatures.DigestAlgorithms;
import com.itextpdf.signatures.cms.AlgorithmIdentifier;
import com.itextpdf.signatures.cms.CmsAttribute;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;

public class SignerInfo {
    private static final IBouncyCastleFactory BC_FACTORY = BouncyCastleFactoryCreator.getFactory();
    private static final int DEFAULT_SIGNATURE_SIZE = 1024;
    private AlgorithmIdentifier digestAlgorithm;
    private AlgorithmIdentifier signingAlgorithm;
    private final Collection<CmsAttribute> signedAttributes = new ArrayList<CmsAttribute>();
    private final Collection<CmsAttribute> unSignedAttributes;
    private byte[] serializedSignedAttributes;
    private Collection<byte[]> ocspResponses;
    private Collection<byte[]> crlResponses;
    private byte[] signatureData;
    private boolean signedAttributesReadOnly;
    private X509Certificate signerCertificate;

    public SignerInfo() {
        CmsAttribute contentType = new CmsAttribute("1.2.840.113549.1.9.3", (IASN1Primitive)BC_FACTORY.createDERSet((IASN1Primitive)BC_FACTORY.createASN1ObjectIdentifier("1.2.840.113549.1.7.1")));
        this.signedAttributes.add(contentType);
        this.unSignedAttributes = new ArrayList<CmsAttribute>();
    }

    public SignerInfo(IASN1Encodable signerInfoStructure, Collection<X509Certificate> certificates) throws IOException {
        int index = 0;
        try {
            IASN1Sequence signerInfoSeq = BC_FACTORY.createASN1Sequence(signerInfoStructure);
            IASN1Integer version = BC_FACTORY.createASN1Integer(signerInfoSeq.getObjectAt(index++));
            if (version.getValue().intValue() == 1) {
                this.processIssuerAndSerialNumberSignerCertificate(signerInfoSeq.getObjectAt(index++), certificates);
            } else {
                this.processSubjectKeyIdentifierSignerCertificate(signerInfoSeq.getObjectAt(index++), certificates);
            }
            this.digestAlgorithm = new AlgorithmIdentifier(signerInfoSeq.getObjectAt(index++));
            IASN1TaggedObject taggedSingedAttributes = BC_FACTORY.createASN1TaggedObject(signerInfoSeq.getObjectAt(index));
            if (taggedSingedAttributes != null) {
                this.setSerializedSignedAttributes(BC_FACTORY.createASN1Set(taggedSingedAttributes, false).getEncoded(BC_FACTORY.createASN1Encoding().getDer()));
            }
            int n = ++index;
            this.signingAlgorithm = new AlgorithmIdentifier(signerInfoSeq.getObjectAt(n));
            int n2 = ++index;
            ++index;
            IDEROctetString signatureDataOS = BC_FACTORY.createDEROctetString(signerInfoSeq.getObjectAt(n2));
            if (signatureDataOS != null) {
                this.signatureData = signatureDataOS.getOctets();
            }
            if (signerInfoSeq.size() > index) {
                IASN1TaggedObject taggedUnsingedAttributes = BC_FACTORY.createASN1TaggedObject(signerInfoSeq.getObjectAt(index));
                this.unSignedAttributes = SignerInfo.processAttributeSet((IASN1Encodable)BC_FACTORY.createASN1Set(taggedUnsingedAttributes, false));
            } else {
                this.unSignedAttributes = new ArrayList<CmsAttribute>();
            }
        }
        catch (NullPointerException npe) {
            throw new PdfException("Provided data is not a CMS container", (Throwable)npe);
        }
    }

    public AlgorithmIdentifier getDigestAlgorithm() {
        return this.digestAlgorithm;
    }

    public void setDigestAlgorithm(AlgorithmIdentifier algorithmId) {
        this.digestAlgorithm = algorithmId;
    }

    public void setMessageDigest(byte[] digest) {
        if (this.signedAttributesReadOnly) {
            throw new IllegalStateException("Updating the signed attributes of this SignerInfo instance is not possible because it has been serialized or been initiated from a serialized version.");
        }
        CmsAttribute digestAttribute = new CmsAttribute("1.2.840.113549.1.9.4", (IASN1Primitive)BC_FACTORY.createDERSet((IASN1Primitive)BC_FACTORY.createDEROctetString(digest)));
        this.signedAttributes.add(digestAttribute);
    }

    public void setSigningCertificate(X509Certificate certificate) throws CertificateEncodingException {
        this.signerCertificate = certificate;
        ITBSCertificate tbsCert = BC_FACTORY.createTBSCertificate(certificate.getTBSCertificate());
        if (this.signingAlgorithm != null) {
            return;
        }
        if (tbsCert.getSubjectPublicKeyInfo().getAlgorithm().getParameters() != null) {
            if (tbsCert.getSubjectPublicKeyInfo().getAlgorithm().getParameters().isNull()) {
                this.signingAlgorithm = new AlgorithmIdentifier(tbsCert.getSubjectPublicKeyInfo().getAlgorithm().getAlgorithm().getId(), (IASN1Primitive)BC_FACTORY.createDERNull());
                return;
            }
            this.signingAlgorithm = new AlgorithmIdentifier(tbsCert.getSubjectPublicKeyInfo().getAlgorithm().getAlgorithm().getId(), tbsCert.getSubjectPublicKeyInfo().getAlgorithm().getParameters().toASN1Primitive());
            return;
        }
        this.signingAlgorithm = new AlgorithmIdentifier(tbsCert.getSubjectPublicKeyInfo().getAlgorithm().getAlgorithm().getId());
    }

    public X509Certificate getSigningCertificate() {
        return this.signerCertificate;
    }

    public void setSigningCertificateAndAddToSignedAttributes(X509Certificate certificate, String digestAlgorithmOid) throws CertificateEncodingException, NoSuchAlgorithmException, NoSuchProviderException {
        this.setSigningCertificate(certificate);
        this.addSignerCertificateToSignedAttributes(certificate, digestAlgorithmOid);
    }

    public void setOcspResponses(Collection<byte[]> ocspResponses) {
        if (this.signedAttributesReadOnly) {
            throw new IllegalStateException("Updating the signed attributes of this SignerInfo instance is not possible because it has been serialized or been initiated from a serialized version.");
        }
        this.ocspResponses = Collections.unmodifiableCollection(ocspResponses);
        this.setRevocationInfo();
    }

    public void setCrlResponses(Collection<byte[]> crlResponses) {
        if (this.signedAttributesReadOnly) {
            throw new IllegalStateException("Updating the signed attributes of this SignerInfo instance is not possible because it has been serialized or been initiated from a serialized version.");
        }
        this.crlResponses = Collections.unmodifiableCollection(crlResponses);
        this.setRevocationInfo();
    }

    public void addSignerCertificateToSignedAttributes(X509Certificate cert, String digestAlgorithmOid) throws NoSuchAlgorithmException, NoSuchProviderException, CertificateEncodingException {
        if (this.signedAttributesReadOnly) {
            throw new IllegalStateException("Updating the signed attributes of this SignerInfo instance is not possible because it has been serialized or been initiated from a serialized version.");
        }
        MessageDigest md = DigestAlgorithms.getMessageDigestFromOid(digestAlgorithmOid, BC_FACTORY.getProviderName());
        IASN1EncodableVector certContents = BC_FACTORY.createASN1EncodableVector();
        if (!"2.16.840.1.101.3.4.2.1".equals(digestAlgorithmOid)) {
            IAlgorithmIdentifier algoId = BC_FACTORY.createAlgorithmIdentifier(BC_FACTORY.createASN1ObjectIdentifier(digestAlgorithmOid));
            certContents.add(algoId);
        }
        byte[] dig = md.digest(cert.getEncoded());
        certContents.add((IASN1Primitive)BC_FACTORY.createDEROctetString(dig));
        IASN1Sequence issuerName = BC_FACTORY.createASN1Sequence((IASN1Encodable)CertificateInfo.getIssuer(cert.getTBSCertificate()));
        IDERTaggedObject issuerTagged = BC_FACTORY.createDERTaggedObject(true, 4, (IASN1Primitive)issuerName);
        IDERSequence issuer = BC_FACTORY.createDERSequence((IASN1Primitive)issuerTagged);
        IASN1Integer serial = BC_FACTORY.createASN1Integer(cert.getSerialNumber());
        IASN1EncodableVector v = BC_FACTORY.createASN1EncodableVector();
        v.add((IASN1Primitive)issuer);
        v.add((IASN1Primitive)serial);
        IDERSequence issuerS = BC_FACTORY.createDERSequence(v);
        certContents.add((IASN1Primitive)issuerS);
        IDERSequence certContentsSeq = BC_FACTORY.createDERSequence(certContents);
        IDERSequence certContentsSeqSeq = BC_FACTORY.createDERSequence((IASN1Primitive)certContentsSeq);
        IDERSequence certContentsSeqSeqSeq = BC_FACTORY.createDERSequence((IASN1Primitive)certContentsSeqSeq);
        IDERSet certContentsSeqSeqSeqSet = BC_FACTORY.createDERSet((IASN1Primitive)certContentsSeqSeqSeq);
        CmsAttribute attribute = new CmsAttribute("1.2.840.113549.1.9.16.2.47", (IASN1Primitive)certContentsSeqSeqSeqSet);
        this.signedAttributes.add(attribute);
    }

    public void setSignature(byte[] signatureData) {
        this.signatureData = Arrays.copyOf(signatureData, signatureData.length);
    }

    public void setSignatureAlgorithm(AlgorithmIdentifier algorithm) {
        this.signingAlgorithm = algorithm;
    }

    public int getCmsVersion() {
        return 1;
    }

    public Collection<CmsAttribute> getSignedAttributes() {
        return Collections.unmodifiableCollection(this.signedAttributes);
    }

    public void addSignedAttribute(CmsAttribute attribute) {
        if (this.signedAttributesReadOnly) {
            throw new IllegalStateException("Updating the signed attributes of this SignerInfo instance is not possible because it has been serialized or been initiated from a serialized version.");
        }
        this.signedAttributes.add(attribute);
    }

    public Collection<CmsAttribute> getUnSignedAttributes() {
        return Collections.unmodifiableCollection(this.unSignedAttributes);
    }

    public void addUnSignedAttribute(CmsAttribute attribute) {
        this.unSignedAttributes.add(attribute);
    }

    public byte[] serializeSignedAttributes() throws IOException {
        if (!this.signedAttributesReadOnly) {
            IDERSet derView = SignerInfo.getAttributesAsDERSet(this.signedAttributes);
            this.serializedSignedAttributes = derView.getEncoded(BC_FACTORY.createASN1Encoding().getDer());
            this.signedAttributesReadOnly = true;
        }
        return Arrays.copyOf(this.serializedSignedAttributes, this.serializedSignedAttributes.length);
    }

    public final void setSerializedSignedAttributes(byte[] serializedSignedAttributes) {
        if (this.signedAttributesReadOnly) {
            throw new IllegalStateException("Updating the signed attributes of this SignerInfo instance is not possible because it has been serialized or been initiated from a serialized version.");
        }
        this.signedAttributesReadOnly = true;
        this.serializedSignedAttributes = Arrays.copyOf(serializedSignedAttributes, serializedSignedAttributes.length);
        try {
            this.signedAttributes.clear();
            this.signedAttributes.addAll(SignerInfo.processAttributeSet((IASN1Encodable)BC_FACTORY.createASN1Primitive(serializedSignedAttributes)));
        }
        catch (IOException e) {
            throw new PdfException((Throwable)e);
        }
    }

    public long getEstimatedSize() throws IOException, CertificateEncodingException {
        IDERSequence derView = this.getAsDerSequence(true);
        byte[] temp = derView.getEncoded(BC_FACTORY.createASN1Encoding().getDer());
        return temp.length;
    }

    public IDERSequence getAsDerSequence() throws CertificateEncodingException {
        return this.getAsDerSequence(false);
    }

    IDERSequence getAsDerSequence(boolean estimationRun) throws CertificateEncodingException {
        IASN1EncodableVector signerInfoV = BC_FACTORY.createASN1EncodableVector();
        signerInfoV.add((IASN1Primitive)BC_FACTORY.createASN1Integer(this.getCmsVersion()));
        IASN1EncodableVector issuerAndSerialNumberV = BC_FACTORY.createASN1EncodableVector();
        issuerAndSerialNumberV.add(CertificateInfo.getIssuer(this.signerCertificate.getTBSCertificate()));
        issuerAndSerialNumberV.add((IASN1Primitive)BC_FACTORY.createASN1Integer(this.signerCertificate.getSerialNumber()));
        signerInfoV.add((IASN1Primitive)BC_FACTORY.createDERSequence(issuerAndSerialNumberV));
        IASN1EncodableVector digestalgorithmV = BC_FACTORY.createASN1EncodableVector();
        digestalgorithmV.add((IASN1Primitive)BC_FACTORY.createASN1ObjectIdentifier(this.digestAlgorithm.getAlgorithmOid()));
        digestalgorithmV.addOptional(this.digestAlgorithm.getParameters());
        signerInfoV.add((IASN1Primitive)BC_FACTORY.createDERSequence(digestalgorithmV));
        if (!this.signedAttributes.isEmpty() || this.signedAttributesReadOnly) {
            if (estimationRun || !this.signedAttributesReadOnly) {
                signerInfoV.add((IASN1Primitive)BC_FACTORY.createDERTaggedObject(false, 0, (IASN1Primitive)SignerInfo.getAttributesAsDERSet(this.signedAttributes)));
            } else {
                try (IASN1InputStream saIS = BC_FACTORY.createASN1InputStream(this.serializedSignedAttributes);){
                    signerInfoV.add((IASN1Primitive)BC_FACTORY.createDERTaggedObject(false, 0, saIS.readObject()));
                }
                catch (IOException e) {
                    throw new PdfException((Throwable)e);
                }
            }
        }
        if (this.signingAlgorithm != null) {
            IASN1EncodableVector signatureAlgorithmV = BC_FACTORY.createASN1EncodableVector();
            signatureAlgorithmV.add((IASN1Primitive)BC_FACTORY.createASN1ObjectIdentifier(this.signingAlgorithm.getAlgorithmOid()));
            signatureAlgorithmV.addOptional(this.signingAlgorithm.getParameters());
            signerInfoV.add((IASN1Primitive)BC_FACTORY.createDERSequence(signatureAlgorithmV));
        }
        byte[] workingSignatureData = this.signatureData == null ? new byte[1024] : this.signatureData;
        IDEROctetString signatureDataOS = BC_FACTORY.createDEROctetString(workingSignatureData);
        signerInfoV.add((IASN1Primitive)signatureDataOS);
        if (!this.unSignedAttributes.isEmpty()) {
            signerInfoV.add((IASN1Primitive)BC_FACTORY.createDERTaggedObject(false, 1, (IASN1Primitive)SignerInfo.getAttributesAsDERSet(this.unSignedAttributes)));
        }
        return BC_FACTORY.createDERSequence(signerInfoV);
    }

    private void processSubjectKeyIdentifierSignerCertificate(IASN1Encodable asnStruct, Collection<X509Certificate> certificates) throws IOException {
        IASN1OctetString subjectKeyIdentifierOs = BC_FACTORY.createASN1OctetString((IASN1Encodable)BC_FACTORY.createASN1TaggedObject(asnStruct).getObject());
        try (IASN1InputStream aIn = BC_FACTORY.createASN1InputStream((InputStream)new ByteArrayInputStream(subjectKeyIdentifierOs.getOctets()));){
            IASN1Primitive subjectKeyIdentifier = aIn.readObject();
            for (X509Certificate certificate : certificates) {
                IASN1Primitive ski = CertificateUtil.getExtensionValue(certificate, "2.5.29.14");
                if (!ski.equals(subjectKeyIdentifier)) continue;
                this.signerCertificate = certificate;
                return;
            }
        }
        throw new PdfException("Signer certificate not found in list of certificates");
    }

    private void processIssuerAndSerialNumberSignerCertificate(IASN1Encodable asnStruct, Collection<X509Certificate> certificates) {
        IASN1Sequence signIdSeq = BC_FACTORY.createASN1Sequence(asnStruct);
        IASN1Integer serial = BC_FACTORY.createASN1Integer(signIdSeq.getObjectAt(1));
        for (X509Certificate certificate : certificates) {
            if (!certificate.getSerialNumber().equals(serial.getValue())) continue;
            this.signerCertificate = certificate;
            break;
        }
        if (this.signerCertificate == null) {
            throw new PdfException("Signer certificate not found in list of certificates");
        }
    }

    private static Collection<CmsAttribute> processAttributeSet(IASN1Encodable asnStruct) {
        IASN1Set usaSet = BC_FACTORY.createASN1Set(asnStruct);
        ArrayList<CmsAttribute> attributes = new ArrayList<CmsAttribute>(usaSet.size());
        for (int i = 0; i < usaSet.size(); ++i) {
            IASN1Sequence attrSeq = BC_FACTORY.createASN1Sequence(usaSet.getObjectAt(i));
            IASN1ObjectIdentifier attrType = BC_FACTORY.createASN1ObjectIdentifier(attrSeq.getObjectAt(0));
            IASN1Primitive attrVal = BC_FACTORY.createASN1Primitive(attrSeq.getObjectAt(1));
            attributes.add(new CmsAttribute(attrType.getId(), attrVal));
        }
        return attributes;
    }

    private void setRevocationInfo() {
        this.signedAttributes.removeIf(a -> "1.2.840.113583.1.1.8".equals(a.getType()));
        if (this.containsRevocationData()) {
            IASN1EncodableVector revocationV = BC_FACTORY.createASN1EncodableVector();
            this.createCRLStructure(revocationV);
            this.createOCPSStructure(revocationV);
            CmsAttribute digestAttribute = new CmsAttribute("1.2.840.113583.1.1.8", (IASN1Primitive)BC_FACTORY.createDERSequence(revocationV));
            this.signedAttributes.add(digestAttribute);
        }
    }

    private void createCRLStructure(IASN1EncodableVector revocationV) {
        if (this.crlResponses != null && !this.crlResponses.isEmpty()) {
            IASN1EncodableVector v2 = BC_FACTORY.createASN1EncodableVector();
            for (byte[] bCrl : this.crlResponses) {
                if (bCrl == null) continue;
                try {
                    IASN1InputStream t = BC_FACTORY.createASN1InputStream((InputStream)new ByteArrayInputStream(bCrl));
                    Throwable throwable = null;
                    try {
                        v2.add(t.readObject());
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (t == null) continue;
                        if (throwable != null) {
                            try {
                                t.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        t.close();
                    }
                }
                catch (IOException e) {
                    throw new PdfException((Throwable)e);
                }
            }
            revocationV.add((IASN1Primitive)BC_FACTORY.createDERTaggedObject(true, 0, (IASN1Primitive)BC_FACTORY.createDERSequence(v2)));
        }
    }

    private void createOCPSStructure(IASN1EncodableVector revocationV) {
        if (this.ocspResponses != null && !this.ocspResponses.isEmpty()) {
            IASN1EncodableVector vo1 = BC_FACTORY.createASN1EncodableVector();
            for (byte[] ocspBytes : this.ocspResponses) {
                IDEROctetString doctet = BC_FACTORY.createDEROctetString(ocspBytes);
                IASN1EncodableVector v2 = BC_FACTORY.createASN1EncodableVector();
                IOCSPObjectIdentifiers objectIdentifiers = BC_FACTORY.createOCSPObjectIdentifiers();
                v2.add((IASN1Primitive)objectIdentifiers.getIdPkixOcspBasic());
                v2.add((IASN1Primitive)doctet);
                IASN1Enumerated den = BC_FACTORY.createASN1Enumerated(0);
                IASN1EncodableVector v3 = BC_FACTORY.createASN1EncodableVector();
                v3.add((IASN1Primitive)den);
                v3.add((IASN1Primitive)BC_FACTORY.createDERTaggedObject(true, 0, (IASN1Primitive)BC_FACTORY.createDERSequence(v2)));
                vo1.add((IASN1Primitive)BC_FACTORY.createDERSequence(v3));
            }
            revocationV.add((IASN1Primitive)BC_FACTORY.createDERTaggedObject(true, 1, (IASN1Primitive)BC_FACTORY.createDERSequence(vo1)));
        }
    }

    private boolean containsRevocationData() {
        return this.ocspResponses != null && !this.ocspResponses.isEmpty() || this.crlResponses != null && !this.crlResponses.isEmpty();
    }

    private static IDERSet getAttributesAsDERSet(Collection<CmsAttribute> attributeSet) {
        IASN1EncodableVector attributes = BC_FACTORY.createASN1EncodableVector();
        for (CmsAttribute attr : attributeSet) {
            IASN1EncodableVector v = BC_FACTORY.createASN1EncodableVector();
            v.add((IASN1Primitive)BC_FACTORY.createASN1ObjectIdentifier(attr.getType()));
            v.add(attr.getValue());
            attributes.add((IASN1Primitive)BC_FACTORY.createDERSequence(v));
        }
        return BC_FACTORY.createDERSet(attributes);
    }
}

